;==========================================================================
;Version history:
;==========================================================================
;2010/01/14     First edition
;==========================================================================
D_InputDebounceLevel:   .EQU    16D     ;Debounce stable count
;==========================================================================
        .DATA
R_InputTemp:            .DS     1
R_KeyBuf:               .DS     1       ;Register of mapping key pad status
R_KeyStroke:            .DS     1       ;Key changed from 0 -> 1
R_KeyRelease:           .DS     1       ;Key changed from 1 -> 0
R_InputDebounceCnt:     .DS     1
R_InputDebounce:        .DS     1
;==========================================================================
P_InputAtt:             .EQU    P_IOA_Att
P_InputBuf:             .EQU    P_IOA_Buf
P_InputDir:             .EQU    P_IOA_Dir
P_InputData:            .EQU    P_IOA_Data
;==========================================================================
%IntDecInputDebounceTimer:      .MACRO
        LDA     R_InputDebounceCnt
        AND     #01111111B
        BEQ     ?L_EndCounting#
        DEC     R_InputDebounceCnt
?L_EndCounting#:
                                .ENDM
;==========================================================================
%InputPowerUpInitial:   .MACRO
        LDA     #00H
        STA     R_KeyStroke
        STA     R_KeyRelease
        STA     R_InputDebounce
        STA     R_KeyBuf
        LDA     #D_InputDebounceLevel+80H
        STA     R_InputDebounceCnt

        LDA     P_INT_CtrlL
        ORA     #D_TB4096IntEn
        STA     P_INT_CtrlL             ;Enable 4096 IRQ for key debounce

        LDA     #00H                    ;IOA = Input Pull-low
        STA     P_InputBuf
        STA     P_InputDir
        STA     P_InputAtt
        CLI
                        .ENDM
;==========================================================================
%InputWakeUpInitial:    .MACRO
        LDA     #00H
        STA     R_KeyStroke
        STA     R_KeyRelease
        STA     R_InputDebounce
        STA     R_KeyBuf
        LDA     #D_InputDebounceLevel+80H
        STA     R_InputDebounceCnt

        LDA     P_INT_CtrlL
        ORA     #D_TB4096IntEn
        STA     P_INT_CtrlL             ;Enable 4096 IRQ for key debounce

        LDA     #00H                    ;IOA = Input Pull-low
        STA     P_InputBuf
        STA     P_InputDir
        STA     P_InputAtt
        CLI
                        .ENDM
;==========================================================================
